/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.dialog;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.logo.util.ProgramException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class LookAndFeelPanel
extends DataInputPanel {
    protected JList fList = null;
    protected JLabel fHintLabel = null;
    protected String[] fUIClassNames;
    protected int fActualLookAndFeel = -1;

    public LookAndFeelPanel() {
        this.initComponents();
    }

    public void loadFieldContents() throws ProgramException {
        UIManager.LookAndFeelInfo[] lookAndFeelInfo = UIManager.getInstalledLookAndFeels();
        String[] names = new String[lookAndFeelInfo.length];
        this.fUIClassNames = new String[lookAndFeelInfo.length];
        LookAndFeel actulalLookAndFeelObject = UIManager.getLookAndFeel();
        for (int i = 0; i < lookAndFeelInfo.length; ++i) {
            names[i] = lookAndFeelInfo[i].getName();
            this.fUIClassNames[i] = lookAndFeelInfo[i].getClassName();
            if (actulalLookAndFeelObject == null || names[i] != actulalLookAndFeelObject.getName()) continue;
            this.fActualLookAndFeel = i;
        }
        this.fList.setSelectionMode(0);
        this.fList.setListData(names);
        this.fList.setSelectedIndex(this.fActualLookAndFeel);
    }

    public String getTitle() {
        return Language.getString("uiChooserPanel.title", "Choose UI");
    }

    protected void initComponents() {
        this.setLayout(new BorderLayout());
        this.fList = new JList();
        this.add((Component)this.fList, "Center");
        this.fHintLabel = new JLabel(Language.getString("dialog.lookAndFeel.hint", "Complete LookAndFeel after restart of Application"));
        this.fHintLabel.setPreferredSize(new Dimension(200, 50));
        this.add((Component)this.fHintLabel, "South");
    }

    public boolean checkChanged() {
        return this.fList.getSelectedIndex() != this.fActualLookAndFeel;
    }

    public void storeFieldContents() {
        try {
            this.fActualLookAndFeel = this.fList.getSelectedIndex();
            String lafClassName = this.fUIClassNames[this.fActualLookAndFeel];
            LookAndFeel lookAndFeel = (LookAndFeel)Class.forName(lafClassName).newInstance();
            UIManager.setLookAndFeel(lookAndFeel);
            SwingUtilities.updateComponentTreeUI(Application.getInstance().getWindow());
            JRootPane rootPane = SwingUtilities.getRootPane(this);
            if (rootPane != null) {
                SwingUtilities.updateComponentTreeUI(rootPane);
            }
            Application.getInstance().createFileChooser();
            LogoProperties.instance().setProperty("app.laf", lafClassName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.toString());
        }
    }
}

